# Copyright (C) 2021-2025 MicroSys Electronics GmbH
# Authors: 
# - Kay Potthoff <kay.potthoff@microsys.de>
# - Florian Aigner <florian.aigner@microsys.de>
# - Falk Schoenfeld <falk.schoenfeld@microsys.de>

inherit microsys

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"
PATCHTOOL = "git"
PATCH_COMMIT_FUNCTIONS = "1"

SRC_URI:append = " file://atf.patch"

PROVIDES += "virtual/arm-trusted-firmware"

inherit deploy

PACKAGE_ARCH ??= "${MACHINE_ARCH}"

do_compile[depends] = "u-boot-s32:do_install"
do_compile[deptask] += "u-boot-s32:do_patch"

BUILD_MESSAGE_TIMESTAMP = "${@microsys_get_iso_datetime_str(d)}"

python do_patch:prepend() {
    if d.getVar('PATCHTOOL') == 'git':
        srcsubdir = d.getVar('S')
        bb.process.run('git config am.threeWay true', cwd=srcsubdir)
        bb.process.run('git config am.keepcr true', cwd=srcsubdir)
        bb.process.run('git config apply.whitespace fix', cwd=srcsubdir)
        bb.process.run('git config apply.ignoreWhitespace change', cwd=srcsubdir)
}

PLATFORM ?= "${MACHINE}"

# missmatch between recipe and actual naming
ATF_PLAT ?= "${PLATFORM}"
TFA_PLAT ?= "${PLATFORM}"

ATF_BINARIES ?= "${TFA_BINARIES}"

COMPATIBLE_MACHINE .= "|(mpxs32g)"

# The package is empty which leads to problems when building mage with devtool.
# This fix lets devtool build the image with modified arm-trusted-firmware.
#ALLOW_EMPTY_${PN} = "1"

# Set log-level:
#       0  (LOG_LEVEL_NONE)
#       10 (LOG_LEVEL_ERROR)
#       20 (LOG_LEVEL_NOTICE)
#       30 (LOG_LEVEL_WARNING)
#       40 (LOG_LEVEL_INFO)
#       50 (LOG_LEVEL_VERBOSE)
# Default is LOG_LEVEL_INFO (40):
# EXTRA_OEMAKE += "LOG_LEVEL=50"

# Uncomment these lines for more debugging:
# BUILD_TYPE = "debug"

EXTRA_OEMAKE += "S32G_USE_LINFLEX_IN_BL31=1"

do_compile:prepend() {

    if [ -f ${S}/localversion-microsys ]; then
        BUILD_STRING=`cat ${S}/localversion-microsys`
    else
        BUILD_STRING=${DISTRO_VERSION}
    fi

    export BUILD_MESSAGE_TIMESTAMP="\"${BUILD_MESSAGE_TIMESTAMP}\""
    export BUILD_STRING="${BUILD_STRING}"
}

do_install:append() {
    install -m 0755 -o root -g root -d ${D}/boot
    install -m 0644 -o root -g root ${ATF_BINARIES}/${FLASHIMAGE_FIP_FILE} ${D}/boot
}

do_configure:append() {
	for suffix in ${BOOT_TYPE}
	do
		if ${@bb.utils.contains('DISTRO_FEATURES', 'hse', 'true', 'false', d)}; then
			hse_backup_fw=\""${STAGING_BASELIBDIR}/firmware/s32cc_hse_backup_fw.bin\""
			sed -i "s,\(HSE_SECONDARY_FW \).*,\1${hse_backup_fw}," ${WORKDIR}/tools/u-boot-s32.cfgout-${suffix}
		fi
	done
}

FILES:${PN} += "/boot"
